// Fiziksel objeleri yakalama değerlerine atıyoruz
var scene = document.getElementById("scene");
var info = document.getElementById("info");
var head = document.getElementById("head");
var headImage = document.getElementById("headImage");
var down = document.getElementById("down");
var bullets = document.getElementById("bullets");
var enemies = document.getElementById("enemies");
var scoreboard = document.getElementById("scoreboard");
var fireSound = document.getElementById("fireSound");
var explodeSound = document.getElementById("explodeSound");

let score = 0;

let winX = window.innerWidth;
let winY = window.innerHeight;
let centerX = winX / 2;
let centerY = winY / 2;

window.onresize = function (params) {
    winX = window.innerWidth;
    winY = window.innerHeight;
    centerX = winX / 2;
    centerY = winY / 2;
}

document.onmousemove = function (event) {
    const deltaX = event.clientX - centerX;
    const deltaY = event.clientY - centerY;
    const radians = Math.atan2(deltaY, deltaX);

    let angle = radians * (180 / Math.PI);

    head.style.rotate = angle + "deg";

    info.innerHTML = "PositionX: " + event.clientX + "px PositionY: " + event.clientY + "px ";
    info.innerHTML += "Angle Deg: " + Math.round(angle);
}

document.onmousedown = function (event) {
    //Fire Animation
    headImage.setAttribute("src", "images/assets/head.gif");
    setTimeout(function () {
        headImage.setAttribute("src", "images/assets/head.png");
    }, 300)

    //Fire Sound
    if(fireSound.currentTime !== 0){
        fireSound.currentTime = 0;
    }
    fireSound.play();

    setTimeout(function () {
       explodeSound.play();
    },300);

    //Bullets
    var bullet = document.createElement("span");
    bullets.appendChild(bullet);

    setTimeout(function () {
        bullet.style.left = event.clientX + "px";
        bullet.style.top = event.clientY + "px";
        setTimeout(function () {
            bullet.remove();
        },300)
    },0);
}

setInterval(function () {
    //Enemies
    var enemy = document.createElement("span");
    enemy.addEventListener("click", function (event) {
        setTimeout(function () {
            enemy.remove();
        },300);

        score++;
        scoreboard.innerHTML = score;
    });
    enemies.appendChild(enemy);
    enemy.style.left = getPosition("x");
    enemy.style.top = getPosition("y");

    setTimeout(function () {
        enemy.style.left = centerX + "px";
        enemy.style.top = centerY + "px";

        setTimeout(function () {
            enemy.remove();
        },6000);
    },300);
}, 5000);

function getPosition(value) {
    while(true){
        if(value === "x"){
            let pos = Math.random() * winX;

            if(pos > 0 && pos < (centerX - 250) || pos > (centerX + 250) && pos < winX) {
                return pos + "px";
            }
        }
        else{
            let pos = Math.random() * winY;

            if(pos > 0 && pos < centerY || pos > centerY && pos < winY) {
                return pos + "px";
            }
        }
    }
}
