// Fiziksel objeleri yakalama değerlerine atıyoruz
var scene = document.getElementById("scene");
var info = document.getElementById("info");
var head = document.getElementById("head");
var headImage = document.getElementById("headImage");
var down = document.getElementById("down");
var bullets = document.getElementById("bullets");
var enemies = document.getElementById("enemy");
var scoreboard = document.getElementById("scoreboard");
var fireSound = document.getElementById("fireSound");
var explodeSound = document.getElementById("explodeSound");

let score = 0;

let winX = window.innerWidth;
let winY = window.innerHeight;

window.onresize = function (params) {
    winX = window.innerWidth;
    winY = window.innerHeight;
}

// Mouse harekelerine ait etkinliği takip ediyoruz
document.onmousemove = function (event) {
    // Ekran ortasını referans noktası olarak belirliyoruz
    const centerX = winX / 2;
    const centerY = winY / 2;

    // Mouse pozisyonunu merkez noktasına göre hesaplıyoruz
    const deltaX = event.clientX - centerX;
    const deltaY = event.clientY - centerY;

    // Radyan cinsinden açı hesaplaması yapıyoruz
    const radians = Math.atan2(deltaY, deltaX);

    // Radyan değerini dereceye çeviriyoruz
    let angle = radians * (180 / Math.PI);

    // Açı hesaplamasını objenin açısına eiştiliyoruz
    head.style.rotate = angle + "deg";

    // Değerleri info ekranına yazdırıyoruz
    info.innerHTML = "PositionX: " + event.clientX + "px PositionY: " + event.clientY + "px ";
    info.innerHTML += "Angle Deg: " + Math.round(angle);
}
